<#ibiztemplate>
TARGET=PSDATAENTITY
</#ibiztemplate>
package ${pub.getPKGCodeName()}.core.${item.getPSSystemModule().getCodeName()?lower_case}.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import lombok.*;
import lombok.extern.slf4j.Slf4j;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

<#comment>SQL存储-Mybatis</#comment>
<#if de.getStorageMode()==1>

import ${pub.getPKGCodeName()}.util.filter.QueryWrapperContext;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import ${pub.getPKGCodeName()}.core.${item.getPSSystemModule().codeName?lower_case}.domain.${item.getCodeName()};
/**
 * 关系型数据实体[${item.codeName}] 查询条件对象
 */
@Slf4j
@Data
public class ${item.codeName}SearchContext extends QueryWrapperContext<${item.codeName}> {

    <#list item.getPSDEFields() as defield>
        <#if defield.getAllPSDEFSearchModes()??>
            <#list defield.getAllPSDEFSearchModes() as formitem>
                <#if formitem.getPSDEField()??>
                    <#assign defDataType=formitem.getPSDEField().getDataType()>
                    <#if defDataType == "DATETIME">
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    @JSONField(format="yyyy-MM-dd HH:mm:ss")
                    <#elseif defDataType == "DATE">
    @JsonFormat(pattern="yyyy-MM-dd", timezone="GMT+8")
    @JSONField(format="yyyy-MM-dd")
                    <#elseif defDataType == "TIME">
    @JsonFormat(pattern="HH:mm", timezone="GMT+8")
    @JSONField(format="HH:mm")
                    </#if>
        <#assign formItemDataType=srfr7javatype(formitem.getPSDEField().stdDataType)>
        <#comment>in条件通过String接，通过split拆后再进行查询</#comment>
        <#if formitem.getValueOp() == "IN">
            <#assign formItemDataType="String">
        </#if>
	private ${formItemDataType} ${formitem.getName()?lower_case};//[${defield.getLogicName()}]
	public void set${formitem.getName()?lower_case?cap_first}(${formItemDataType} ${formitem.getName()?lower_case}) {
        this.${formitem.getName()?lower_case} = ${formitem.getName()?lower_case};
        if(!ObjectUtils.isEmpty(this.${formitem.getName()?lower_case})){
                    <#if formitem.getValueOp() == "LIKE">
            this.getSearchCond().like("${formitem.getPSDEField().getName()?lower_case}", ${formitem.getName()?lower_case});
                    <#elseif formitem.getValueOp() == "LEFTLIKE">
            this.getSearchCond().likeRight("${formitem.getPSDEField().getName()?lower_case}", ${formitem.getName()?lower_case});
                    <#elseif formitem.getValueOp() == "RIGHTLIKE">
            this.getSearchCond().likeLeft("${formitem.getPSDEField().getName()?lower_case}", ${formitem.getName()?lower_case});
                    <#elseif formitem.getValueOp() == "EQ">
            this.getSearchCond().eq("${formitem.getPSDEField().getName()?lower_case}", ${formitem.getName()?lower_case});
                    <#elseif formitem.getValueOp() == "NOTEQ">
            this.getSearchCond().ne("${formitem.getPSDEField().getName()?lower_case}", ${formitem.getName()?lower_case});
                    <#elseif formitem.getValueOp() == "GT">
            this.getSearchCond().gt("${formitem.getPSDEField().getName()?lower_case}", ${formitem.getName()?lower_case});
                    <#elseif formitem.getValueOp() == "GTANDEQ">
            this.getSearchCond().ge("${formitem.getPSDEField().getName()?lower_case}", ${formitem.getName()?lower_case});
                    <#elseif formitem.getValueOp() == "LT">
            this.getSearchCond().lt("${formitem.getPSDEField().getName()?lower_case}", ${formitem.getName()?lower_case});
                    <#elseif formitem.getValueOp() == "LTANDEQ">
            this.getSearchCond().le("${formitem.getPSDEField().getName()?lower_case}", ${formitem.getName()?lower_case});
                    <#elseif formitem.getValueOp() == "ISNOTNULL">
			if(this.${formitem.getName()?lower_case}.toString().equals("1")){
				this.getSearchCond().isNotNull("${formitem.getPSDEField().getName()?lower_case}");
			}
                    <#elseif formitem.getValueOp() == "ISNULL">
			if(this.${formitem.getName()?lower_case}.toString().equals("1")){
				this.getSearchCond().isNull("${formitem.getPSDEField().getName()?lower_case}");
			}
                    <#elseif formitem.getValueOp() == "IN">
                        <#comment>获取分隔符</#comment>
                        <#assign valueSeparator=getInCondSeparator(formitem)>
			this.getSearchCond().in("${formitem.getPSDEField().getName()?lower_case}",this.${formitem.getName()?lower_case}.split("${valueSeparator}"));
                    <#elseif formitem.getValueOp() == "NOTIN">
                        <#comment>获取分隔符</#comment>
                        <#assign valueSeparator=getInCondSeparator(formitem)>
			this.getSearchCond().notIn("${formitem.getPSDEField().getName()?lower_case}",this.${formitem.getName()?lower_case}.split("${valueSeparator}"));
                    </#if>
        }
    }
                </#if>
            </#list>
        </#if>
    </#list>

    /**
	 * 启用快速搜索
	 */
	public void setQuery(String query)
	{
		 this.query=query;
		 if(!StringUtils.isEmpty(query)){
	<#assign bFisrtLoop = true >
	<#assign bHasSearch = false >
    <#list item.getPSDEFields() as defield>
        <#if defield.isEnableQuickSearch()==true >
            <#assign bHasSearch = true >
            <#if bFisrtLoop>
            this.getSearchCond().and( wrapper ->
                     wrapper.like("${defield.name?lower_case}", query)   
            <#assign bFisrtLoop = false >         
            <#else>
                        .or().like("${defield.name?lower_case}", query)            
            </#if>
        </#if>
    </#list>
    <#if bHasSearch>
            );
    </#if>
		 }
	}
}

<#comment>NoSQL存储-MongoDB</#comment>
<#elseif de.getStorageMode()==2>

import ${pub.getPKGCodeName()}.util.filter.QueryBuildContext;
import ${pub.getPKGCodeName()}.core.${item.getPSSystemModule().codeName?lower_case}.domain.${item.getCodeName()};
import java.util.regex.Pattern;
import com.mongodb.BasicDBObject;

/**
 * NoSQL数据实体[${item.codeName}] 查询条件对象
 */
@Slf4j
@Data
public class ${item.codeName}SearchContext extends QueryBuildContext {

    <#list item.getPSDEFields() as defield>
        <#if defield.getAllPSDEFSearchModes()??>
            <#list defield.getAllPSDEFSearchModes() as formitem>
                <#if formitem.getPSDEField()??>
                    <#assign defDataType=formitem.getPSDEField().getDataType()>
                    <#if defDataType == "DATETIME">
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    @JSONField(format="yyyy-MM-dd HH:mm:ss")
                    <#elseif defDataType == "DATE">
    @JsonFormat(pattern="yyyy-MM-dd", timezone="GMT+8")
    @JSONField(format="yyyy-MM-dd")
                    <#elseif defDataType == "TIME">
    @JsonFormat(pattern="HH:mm", timezone="GMT+8")
    @JSONField(format="HH:mm")
                    </#if>
        <#assign formItemDataType=srfr7javatype(formitem.getPSDEField().stdDataType)>
        <#comment>in条件通过String接，通过split拆后再进行查询</#comment>
        <#if formitem.getValueOp() == "IN">
            <#assign formItemDataType="String">
        </#if>
	private ${formItemDataType} ${formitem.getName()?lower_case};//[${defield.getLogicName()}]
	public void set${formitem.getName()?lower_case?cap_first}(${formItemDataType} ${formitem.getName()?lower_case}) {
        this.${formitem.getName()?lower_case} = ${formitem.getName()?lower_case};
        if(!ObjectUtils.isEmpty(this.${formitem.getName()?lower_case})){
                    <#if formitem.getValueOp() == "LIKE">
            Pattern pattern = Pattern.compile("^.*" + ${formitem.getName()?lower_case} + ".*$", Pattern.CASE_INSENSITIVE);
            this.getSearchCond().and("${formitem.getPSDEField().getName()?lower_case}").regex(pattern);
                    <#elseif formitem.getValueOp() == "LEFTLIKE">
            Pattern pattern = Pattern.compile( ${formitem.getName()?lower_case} + ".*$", Pattern.CASE_INSENSITIVE);
            this.getSearchCond().and("${formitem.getPSDEField().getName()?lower_case}").regex(pattern);
                    <#elseif formitem.getValueOp() == "RIGHTLIKE">
            Pattern pattern = Pattern.compile("^.*" + ${formitem.getName()?lower_case} + "$", Pattern.CASE_INSENSITIVE);
            this.getSearchCond().and("${formitem.getPSDEField().getName()?lower_case}").regex(pattern);
                    <#elseif formitem.getValueOp() == "EQ">
            this.getSearchCond().and("${formitem.getPSDEField().getName()?lower_case}").is(${formitem.getName()?lower_case});
                    <#elseif formitem.getValueOp() == "NOTEQ">
            this.getSearchCond().and("${formitem.getPSDEField().getName()?lower_case}").notEquals(${formitem.getName()?lower_case});
                    <#elseif formitem.getValueOp() == "GT">
            this.getSearchCond().and("${formitem.getPSDEField().getName()?lower_case}").greaterThan(${formitem.getName()?lower_case});
                    <#elseif formitem.getValueOp() == "GTANDEQ">
            this.getSearchCond().and("${formitem.getPSDEField().getName()?lower_case}").greaterThanEquals(${formitem.getName()?lower_case});
                    <#elseif formitem.getValueOp() == "LT">
            this.getSearchCond().and("${formitem.getPSDEField().getName()?lower_case}").lessThan(${formitem.getName()?lower_case});
                    <#elseif formitem.getValueOp() == "LTANDEQ">
            this.getSearchCond().and("${formitem.getPSDEField().getName()?lower_case}").lessThanEquals(${formitem.getName()?lower_case});
                    <#elseif formitem.getValueOp() == "ISNOTNULL">
			if(this.${formitem.getName()?lower_case}.toString().equals("1")){
				this.getSearchCond().and("${formitem.getPSDEField().getName()?lower_case}").exists(true).and("${formitem.getPSDEField().getName()?lower_case}").notEquals("").and("${formitem.getPSDEField().getName()?lower_case}").notEquals(null);
			}
                    <#elseif formitem.getValueOp() == "ISNULL">
			if(this.${formitem.getName()?lower_case}.toString().equals("1")){
				this.getSearchCond().and("${formitem.getPSDEField().getName()?lower_case}").exists(null);
			}
                    <#elseif formitem.getValueOp() == "IN">
                        <#comment>获取分隔符</#comment>
                        <#assign valueSeparator=getInCondSeparator(formitem)>
			this.getSearchCond().and("${formitem.getPSDEField().getName()?lower_case}").in(this.${formitem.getName()?lower_case}.split("${valueSeparator}")));
                    <#elseif formitem.getValueOp() == "NOTIN">
                        <#comment>获取分隔符</#comment>
                        <#assign valueSeparator=getInCondSeparator(formitem)>
			this.getSearchCond().and("${formitem.getPSDEField().getName()?lower_case}").notIn(this.${formitem.getName()?lower_case}.split("${valueSeparator}")));
                    </#if>
        }
    }
                </#if>
            </#list>
        </#if>
    </#list>

    /**
	 * 启用快速搜索
	 */
	public void setQuery(String query)
	{
		 this.query=query;
		 if(!StringUtils.isEmpty(query)){
    <#list item.getPSDEFields() as defield>
        <#if defield.isEnableQuickSearch()==true>
            Pattern pattern = Pattern.compile("^.*" + query + ".*$", Pattern.CASE_INSENSITIVE);
            this.getSearchCond().or(new BasicDBObject("${defield.name?lower_case}",pattern));
        </#if>
    </#list>
		 }
	}
}
<#comment>ServiceApi</#comment>
<#elseif de.getStorageMode()==4>

import ${pub.getPKGCodeName()}.util.filter.SearchContextBase;

/**
 * ServiceApi数据实体[${item.codeName}] 查询条件对象
 */
@Slf4j
@Data
public class ${item.codeName}SearchContext extends SearchContextBase {
    <#list item.getPSDEFields() as defield>
        <#if defield.getAllPSDEFSearchModes()??>
            <#list defield.getAllPSDEFSearchModes() as formitem>
                <#if formitem.getPSDEField()??>
                    <#assign defDataType=formitem.getPSDEField().getDataType()>
                    <#if defDataType == "DATETIME">
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    @JSONField(format="yyyy-MM-dd HH:mm:ss")
                    <#elseif defDataType == "DATE">
    @JsonFormat(pattern="yyyy-MM-dd", timezone="GMT+8")
    @JSONField(format="yyyy-MM-dd")
                    <#elseif defDataType == "TIME">
    @JsonFormat(pattern="HH:mm", timezone="GMT+8")
    @JSONField(format="HH:mm")
                    </#if>
        <#assign formItemDataType=srfr7javatype(formitem.getPSDEField().stdDataType)>
        <#comment>in条件通过String接，通过split拆后再进行查询</#comment>
        <#if formitem.getValueOp() == "IN">
            <#assign formItemDataType="String">
        </#if>
	private ${formItemDataType} ${formitem.getName()?lower_case};//[${defield.getLogicName()}]

                </#if>
            </#list>
        </#if>
    </#list>
}
<#elseif de.getStorageMode()==0>

import ${pub.getPKGCodeName()}.util.filter.SearchContextBase;

/**
 * ServiceApi数据实体[${item.codeName}] 查询条件对象
 */
@Slf4j
@Data
public class ${item.codeName}SearchContext extends SearchContextBase {
    <#list item.getPSDEFields() as defield>
        <#if defield.getAllPSDEFSearchModes()??>
            <#list defield.getAllPSDEFSearchModes() as formitem>
                <#if formitem.getPSDEField()??>
                    <#assign defDataType=formitem.getPSDEField().getDataType()>
                    <#if defDataType == "DATETIME">
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    @JSONField(format="yyyy-MM-dd HH:mm:ss")
                    <#elseif defDataType == "DATE">
    @JsonFormat(pattern="yyyy-MM-dd", timezone="GMT+8")
    @JSONField(format="yyyy-MM-dd")
                    <#elseif defDataType == "TIME">
    @JsonFormat(pattern="HH:mm", timezone="GMT+8")
    @JSONField(format="HH:mm")
                    </#if>
        <#assign formItemDataType=srfr7javatype(formitem.getPSDEField().stdDataType)>
        <#comment>in条件通过String接，通过split拆后再进行查询</#comment>
        <#if formitem.getValueOp() == "IN">
            <#assign formItemDataType="String">
        </#if>
	private ${formItemDataType} ${formitem.getName()?lower_case};//[${defield.getLogicName()}]

                </#if>
            </#list>
        </#if>
    </#list>
}
</#if>


<#comment>获取in查询的分隔符</#comment>
<#function getInCondSeparator formitem>
    <#assign valueSeparator=";">
    <#if formitem.getPSCodeListId()??>
        <#assign codelistId=formitem.getPSCodeListId()>
        <#if sys.getPSCodeList(codelistId,true)??>
            <#assign codelist=sys.getPSCodeList(codelistId)>
            <#if codelist.getValueSeparator?? && codelist.getValueSeparator()?? && codelist.getValueSeparator()!=''>
                <#assign valueSeparator=codelist.getValueSeparator()>
            </#if>
        </#if>
    </#if>
    <#return valueSeparator/>
</#function>


